<?php

namespace Import\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;

/**
 * IncomeTaxRate
 *
 * @ORM\Table(name="income_tax_rates")
 * @ORM\Entity(repositoryClass="Import\ApiBundle\Repository\IncomeTaxRateRepository")
 *
 * @ExclusionPolicy("all")
 */
class IncomeTaxRate
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="year", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $year;

    /**
     * @var float
     *
     * @ORM\Column(name="pit_treshold", type="float")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $pit_treshold;

    /**
     * @var string
     *
     * @ORM\Column(name="pit_lower_section_description", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $pit_lower_section_description;

    /**
     * @var string
     *
     * @ORM\Column(name="pit_higher_section_description", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $pit_higher_section_description;

    /**
     * @var float
     *
     * @ORM\Column(name="cit_percent", type="float")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $cit_percent;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="createAt", type="datetime")
     */
    private $createAt;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set year
     *
     * @param integer $year
     * @return IncomeTax
     */
    public function setYear($year)
    {
        $this->year = $year;
    
        return $this;
    }

    /**
     * Get year
     *
     * @return integer 
     */
    public function getYear()
    {
        return $this->year;
    }

    /**
     * Set pit_treshold
     *
     * @param float $pitTreshold
     * @return IncomeTax
     */
    public function setPitTreshold($pitTreshold)
    {
        $this->pit_treshold = $pitTreshold;
    
        return $this;
    }

    /**
     * Get pit_treshold
     *
     * @return float 
     */
    public function getPitTreshold()
    {
        return $this->pit_treshold;
    }

    /**
     * Set pit_lower_section_description
     *
     * @param string $pitLowerSectionDescription
     * @return IncomeTax
     */
    public function setPitLowerSectionDescription($pitLowerSectionDescription)
    {
        $this->pit_lower_section_description = $pitLowerSectionDescription;
    
        return $this;
    }

    /**
     * Get pit_lower_section_description
     *
     * @return string 
     */
    public function getPitLowerSectionDescription()
    {
        return $this->pit_lower_section_description;
    }

    /**
     * Set pit_higher_section_description
     *
     * @param string $pitHigherSectionDescription
     * @return IncomeTax
     */
    public function setPitHigherSectionDescription($pitHigherSectionDescription)
    {
        $this->pit_higher_section_description = $pitHigherSectionDescription;
    
        return $this;
    }

    /**
     * Get pit_higher_section_description
     *
     * @return string 
     */
    public function getPitHigherSectionDescription()
    {
        return $this->pit_higher_section_description;
    }

    /**
     * Set cit_percent
     *
     * @param float $citPercent
     * @return IncomeTax
     */
    public function setCitPercent($citPercent)
    {
        $this->cit_percent = $citPercent;
    
        return $this;
    }

    /**
     * Get cit_percent
     *
     * @return float 
     */
    public function getCitPercent()
    {
        return $this->cit_percent;
    }

    /**
     * Set createAt
     *
     * @param \DateTime $createAt
     * @return IncomeTax
     */
    public function setCreateAt($createAt)
    {
        $this->createAt = $createAt;
    
        return $this;
    }

    /**
     * Get createAt
     *
     * @return \DateTime 
     */
    public function getCreateAt()
    {
        return $this->createAt;
    }
}